<?php

namespace App\Http\Requests;

class UpdatePackageRequest extends StorePackageRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return user()->can('package-edit');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return array_merge(parent::rules(), [
            'thumbnail' => 'nullable|image|mimes:jpeg,png,jpg|max:1024',
            'gallery' => 'nullable|array',
            'gallery.*' => 'required|image|mimes:jpeg,png,jpg|max:1024',
        ]);
    }
}
